/* 
 *  ResourceExecutor.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.request.CallSupervisorRequest;
import com.avaya.ccs.javafxrefclient.request.GetResourceDataRequest;
import com.avaya.ccs.javafxrefclient.request.OriginateVoiceCallRequest;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.ResourceI;
import com.avaya.ccs.api.ResourceListenerI;
import javafx.concurrent.Task;

public class ResourceExecutor extends Executor implements ResourceListenerI {

    private static final Logger LOG = Logger.getLogger(ResourceExecutor.class);
    private final JavaFXRefClient gui;

    public ResourceExecutor(JavaFXRefClient gui) {
        this.gui = gui;
    }

    public void originateCall(String number, String resourceID) {
        String methodName = "originateCall() ";
        LOG.debug(methodName + "+ Number:" + number + " ResourceID:" + resourceID);
        executeOutgoingRequest(new OriginateVoiceCallRequest(resourceID, number));
        LOG.trace(methodName + "-");
    }

    public void callSupervisor(String resourceID) {
        String methodName = "callSupervisor() ";
        LOG.debug(methodName + "+ ResourceID:" + resourceID);
        executeOutgoingRequest(new CallSupervisorRequest(resourceID));
        LOG.trace(methodName + "-");
    }

    public void getResourceData() {
        String methodName = "getResourceData() ";
        LOG.debug(methodName + "+");
        executeOutgoingRequest(new GetResourceDataRequest(gui.getResourceDataGUI()));
        LOG.trace(methodName + "-");
    }

    @Override
    public void onResourceEvent(NotificationEventI<ResourceI> nei) {
        String methodName = "onResourceEvent() ";
        LOG.info(methodName + nei.getNotificationType() + " ResourceI-ID:" + nei.getNotificationObject().getId());
        Task<ResourceData> t = new ResourceEventTask(nei, gui.getResourceDataGUI(), gui.getInteractionDataGUI());
        executeIncomingEvent(t);
    }
}
